/*
 * Decompiled with CFR 0.152.
 */
import Snmp.SnmpAPI;
import Snmp.SnmpException;
import Snmp.SnmpInt;
import Snmp.SnmpPDU;
import Snmp.SnmpSession;
import Snmp.SnmpUnsignedInt;
import Snmp.SnmpVarBind;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IndexMapper
implements Runnable {
    public boolean infoReady = false;
    public boolean infoError = false;
    private boolean exitFlag = false;
    private static final int NO_GROUP = -1;
    private String ipAddress;
    private Hashtable indexMap;
    private Hashtable groupMap;
    private Hashtable usageMap;
    private Hashtable duplexMap;
    private Hashtable speedMap;
    private SnmpSession session;
    private SnmpAPI api;
    private static int mcounter = 1;
    private String readCommunityString;

    IndexMapper(String string, String string2) {
        this.ipAddress = string;
        this.readCommunityString = string2;
        this.indexMap = new Hashtable();
        this.groupMap = new Hashtable();
        this.usageMap = new Hashtable();
        this.duplexMap = new Hashtable();
        this.speedMap = new Hashtable();
        Thread thread = new Thread((Runnable)this, "IndexMapper-" + mcounter++);
        thread.start();
    }

    public int mapToIfIndex(String string) {
        return this.getGroupIndex(this.dottedForm(string));
    }

    public String mapToModulePortIndex(String string) {
        return this.dottedForm(string);
    }

    public int getSpeed(String string) {
        String string2 = this.dottedForm(string);
        Vector vector = this.getGroupList(string2);
        int n = this.getGroupIndex(string2);
        if (vector.size() == 1) {
            Integer n2 = (Integer)this.speedMap.get(String.valueOf(n));
            if (n2 == null) {
                return 0;
            }
            return n2;
        }
        Integer n3 = (Integer)this.speedMap.get(String.valueOf(n));
        if (n3 == null) {
            return 0;
        }
        return n3;
    }

    public int getGroupIndex(String string) {
        Integer n = (Integer)this.groupMap.get(string);
        if (n == null) {
            return 0;
        }
        int n2 = n;
        if (n2 == -1) {
            return this.getIfIndex(string);
        }
        int n3 = -1;
        int n4 = 0;
        Enumeration enumeration = this.indexMap.keys();
        while (enumeration.hasMoreElements()) {
            int n5;
            Integer n6;
            String string2 = (String)enumeration.nextElement();
            int n7 = (Integer)this.groupMap.get(string2);
            if (n7 != n2 || (n6 = (Integer)this.speedMap.get(String.valueOf(n5 = ((Integer)this.indexMap.get(string2)).intValue()))) <= n3) continue;
            n3 = n6;
            n4 = n5;
        }
        return n4;
    }

    private Vector getGroupList(String string) {
        return new Vector();
    }

    private String dottedForm(String string) {
        int n = string.indexOf(47);
        String string2 = string.substring(n - 1, n);
        String string3 = string.substring(n + 1);
        return String.valueOf(string2) + "." + string3;
    }

    public int getIfIndex(String string) {
        Integer n = (Integer)this.indexMap.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void run() {
        int n;
        String string;
        this.api = new SnmpAPI();
        this.api.start();
        while (this.api.client == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        MibCache mibCache = new MibCache();
        this.session = new SnmpSession(this.api);
        this.session.peername = this.ipAddress;
        this.session.community = this.readCommunityString;
        try {
            this.session.open();
        }
        catch (SnmpException snmpException) {
            System.err.println("Snmp Exception " + snmpException.getMessage());
            return;
        }
        String string2 = mibCache.getMibVar("c2900PortIfIndex");
        this.session.retries = 2;
        this.session.timeout = 4000;
        SnmpPDU snmpPDU = null;
        SnmpPDUExt snmpPDUExt = null;
        String string3 = ".0";
        String string4 = SnmpPDUExt.getMibVar((String)"c2900PortIfIndex");
        boolean bl = false;
        int n2 = 1;
        while (!bl) {
            snmpPDUExt = new SnmpPDUExt(this.api);
            snmpPDUExt.command = (byte)-95;
            snmpPDUExt.addRequest("c2900PortIfIndex", string3);
            snmpPDUExt.addRequest("c2900PortDuplexStatus", string3);
            snmpPDUExt.addRequest("c2900PortUsageApplication", string3);
            snmpPDUExt.addRequest("c2900PortGroupIndex", string3);
            snmpPDU = this.requestFromSNMP((SnmpPDU)snmpPDUExt);
            if (snmpPDU != null) {
                if (snmpPDU.errstat != 0) break;
                string = (SnmpVarBind)snmpPDU.variables.elementAt(0);
                String string5 = ((SnmpVarBind)string).oid.toString();
                if (string5.startsWith(string4)) {
                    string3 = string5.substring(string4.length());
                    n = 0;
                    while (n < snmpPDU.variables.size()) {
                        this.recordData(snmpPDU, n, string2);
                        n += 4;
                    }
                } else {
                    bl = true;
                }
            } else {
                this.infoError = true;
                return;
            }
            ++n2;
        }
        string = SnmpPDUExt.getMibVar((String)"ifSpeed");
        snmpPDUExt = new SnmpPDUExt(this.api);
        snmpPDUExt.command = (byte)-96;
        snmpPDUExt.addRequest("ifNumber", ".0");
        snmpPDU = this.requestFromSNMP((SnmpPDU)snmpPDUExt);
        if (snmpPDU != null && snmpPDU.errstat == 0) {
            int n3 = ((SnmpInt)((SnmpVarBind)snmpPDU.variables.elementAt((int)0)).variable).intValue();
            n = 8;
            int n4 = 0;
            int n5 = 1;
            block7: while (n4 < n3) {
                snmpPDUExt = new SnmpPDUExt(this.api);
                snmpPDUExt.command = (byte)-96;
                int n6 = n5;
                while (n6 < n5 + n) {
                    if (n6 - n5 >= n3 - n4) break;
                    snmpPDUExt.addRequest("ifSpeed", "." + n6);
                    ++n6;
                }
                if ((snmpPDU = this.requestFromSNMP((SnmpPDU)snmpPDUExt)) != null) {
                    if (snmpPDU.errstat == 0) {
                        int n7 = 0;
                        while (n7 < n) {
                            SnmpVarBind snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n7);
                            string3 = snmpVarBind.oid.toString().substring(string.length() + 1);
                            int n8 = (int)((SnmpUnsignedInt)snmpVarBind.variable).longValue();
                            this.speedMap.put(string3, new Integer(n8));
                            ++n5;
                            if (++n4 == n3) continue block7;
                            ++n7;
                        }
                        continue;
                    }
                    if (n > 1) {
                        n = 1;
                        continue;
                    }
                    n = 8;
                    ++n5;
                    continue;
                }
                this.infoError = true;
                return;
            }
        } else {
            this.infoError = true;
            return;
        }
        this.session.close();
        this.session = null;
        this.api.stop();
        this.api = null;
        this.infoReady = true;
    }

    private void recordData(SnmpPDU snmpPDU, int n, String string) {
        Integer n2 = new Integer(-1);
        SnmpVarBind snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n);
        String string2 = snmpVarBind.oid.toString().substring(string.length() + 1);
        this.indexMap.put(string2, new Integer(((SnmpInt)snmpVarBind.variable).intValue()));
        snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n + 1);
        this.duplexMap.put(string2, new Integer(((SnmpInt)snmpVarBind.variable).intValue()));
        snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n + 2);
        int n3 = ((SnmpInt)snmpVarBind.variable).intValue();
        this.usageMap.put(string2, new Integer(n3));
        if (n3 == 4 || n3 == 6) {
            snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n + 3);
            this.groupMap.put(string2, new Integer(((SnmpInt)snmpVarBind.variable).intValue()));
            return;
        }
        this.groupMap.put(string2, n2);
    }

    public void stop() {
        this.exitFlag = true;
        if (this.session != null) {
            this.session.close();
        }
        if (this.api != null) {
            this.api.stop();
        }
    }

    private SnmpPDU requestFromSNMP(SnmpPDU snmpPDU) {
        int n;
        SnmpPDU snmpPDU2 = null;
        try {
            n = this.session.send(snmpPDU);
        }
        catch (SnmpException snmpException) {
            return null;
        }
        boolean bl = false;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.exitFlag) {
                return null;
            }
            snmpPDU2 = this.session.receive(n);
            bl = this.session.checkTimeout(n);
        } while (snmpPDU2 == null && !bl);
        return snmpPDU2;
    }
}

