/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class ImageButton
extends ImageLabel {
    protected static final int defaultBorderWidth = 4;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private boolean mouseIsDown = false;
    private int darkness = -5263441;
    private Image grayImage;
    protected URL imageURL;

    public ImageButton() {
        this.setBorders();
    }

    public ImageButton(String string) {
        super(string);
        try {
            this.imageURL = new URL(string);
        }
        catch (Exception exception) {
            System.out.println("ImageButton: new URL(" + string + ") Failed!");
            exception.printStackTrace();
        }
        this.setBorders();
    }

    public ImageButton(URL uRL) {
        super(uRL);
        this.imageURL = uRL;
        this.setBorders();
    }

    public ImageButton(URL uRL, String string) {
        super(uRL, string);
        try {
            this.imageURL = new URL(uRL, string);
        }
        catch (Exception exception) {
            System.out.println("ImageButton: new URL(" + uRL + string + ") Failed!");
            exception.printStackTrace();
        }
        this.setBorders();
    }

    public ImageButton(Image image) {
        super(image);
        this.setBorders();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.grayImage == null) {
            this.createGrayImage(graphics);
        }
        this.drawBorder(true);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseIsDown = true;
        Graphics graphics = this.getGraphics();
        int n3 = this.getBorder();
        if (this.hasExplicitSize()) {
            graphics.drawImage(this.grayImage, n3, n3, this.getWidth() - 2 * n3, this.getHeight() - 2 * n3, this);
        } else {
            graphics.drawImage(this.grayImage, n3, n3, this);
        }
        this.drawBorder(false);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.mouseIsDown = false;
        if (this.contains(n, n2)) {
            this.paint(this.getGraphics());
            event.id = 1001;
            event.arg = this.getImage();
            return this.action(event, event.arg);
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
        return true;
    }

    public int getDarkness() {
        return this.darkness;
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setDarkness(int n) {
        this.darkness = n;
    }

    public Image getGrayImage() {
        return this.grayImage;
    }

    public void setGrayImage(Image image) {
        this.grayImage = image;
    }

    private void drawBorder(boolean bl) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(this.getBorderColor());
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getBorder();
        int n6 = 0;
        while (n6 < n5) {
            graphics.draw3DRect(n, n2, n3, n4, bl);
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
            ++n6;
        }
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGrayImage(Graphics graphics) {
        GrayFilter grayFilter = new GrayFilter(this.darkness);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getImage().getSource(), grayFilter);
        this.grayImage = this.createImage(filteredImageSource);
        int n = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.grayImage, this.getWidth() - 2 * n, this.getHeight() - 2 * n, this);
        } else {
            this.prepareImage(this.grayImage, this);
        }
        super.paint(graphics);
    }
}

