/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.SnmpCounter;
import Snmp.SnmpException;
import Snmp.SnmpGauge;
import Snmp.SnmpInt;
import Snmp.SnmpIpAddress;
import Snmp.SnmpNull;
import Snmp.SnmpOID;
import Snmp.SnmpOpaque;
import Snmp.SnmpString;
import Snmp.SnmpTimeticks;
import Snmp.SnmpVar;
import java.io.ByteArrayInputStream;

public class ASNTypes {
    static int MAX_SUBID = -1;
    static int MAX_OID_LEN = 64;
    static final byte ASN_BOOLEAN = 1;
    static final byte ASN_INTEGER = 2;
    static final byte ASN_BIT_STR = 3;
    static final byte ASN_OCTET_STR = 4;
    static final byte ASN_NULL = 5;
    static final byte ASN_OBJECT_ID = 6;
    static final byte ASN_SEQUENCE = 16;
    static final byte ASN_SET = 17;
    static final byte ASN_UNIVERSAL = 0;
    static final byte ASN_APPLICATION = 64;
    static final byte ASN_CONTEXT = -128;
    static final byte ASN_PRIVATE = -64;
    static final byte ASN_PRIMITIVE = 0;
    static final byte ASN_CONSTRUCTOR = 32;
    static final byte ASN_LONG_LEN = -128;
    static final byte ASN_EXTENSION_ID = 31;
    static final byte ASN_BIT8 = -128;

    public static SnmpVar decodeVar(ByteArrayInputStream byteArrayInputStream) throws SnmpException {
        SnmpVar snmpVar = null;
        int[] nArray = ASNTypes.parse_header(byteArrayInputStream);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] == -1) {
            return null;
        }
        if (nArray[0] == 2) {
            snmpVar = new SnmpInt(0);
        } else if (nArray[0] == 4) {
            snmpVar = new SnmpString(null);
        } else if (nArray[0] == 6) {
            snmpVar = new SnmpOID(null);
        } else if (nArray[0] == 5) {
            snmpVar = new SnmpNull();
        } else if (nArray[0] == 64) {
            snmpVar = new SnmpIpAddress("0.0.0.0");
        } else if (nArray[0] == 65) {
            snmpVar = new SnmpCounter(0L);
        } else if (nArray[0] == 66) {
            snmpVar = new SnmpGauge(0L);
        } else if (nArray[0] == 67) {
            snmpVar = new SnmpTimeticks(0L);
        } else if (nArray[0] == 68) {
            snmpVar = new SnmpOpaque(null);
        } else {
            throw new SnmpException("Cannot decode ASN Type: " + nArray[0]);
        }
        snmpVar.Type = (byte)nArray[0];
        ((SnmpVar)snmpVar).decode(byteArrayInputStream, nArray[1]);
        return snmpVar;
    }

    static byte[] build_header(byte by, int n) {
        byte[] byArray = ASNTypes.build_length(n);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        byArray2[0] = by;
        return byArray2;
    }

    static int[] parse_header(ByteArrayInputStream byteArrayInputStream) throws SnmpException {
        ASNTypes.checkStream(byteArrayInputStream, 2);
        byte by = (byte)byteArrayInputStream.read();
        if (ASNTypes.IS_EXTENSION_ID(by)) {
            throw new SnmpException("Parse error: can't process ID >= 30");
        }
        int[] nArray = new int[]{by, ASNTypes.parse_length(byteArrayInputStream)};
        return nArray;
    }

    static byte[] build_length(int n) {
        byte[] byArray = n < 128 ? new byte[]{(byte)n} : (n <= 255 ? new byte[]{-127, (byte)n} : new byte[]{-126, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)});
        return byArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static int parse_length(ByteArrayInputStream byteArrayInputStream) throws SnmpException {
        int n;
        block6: {
            byte by;
            byte by2;
            block5: {
                ASNTypes.checkStream(byteArrayInputStream, 1);
                by2 = (byte)byteArrayInputStream.read();
                n = -1;
                if ((by2 & 0xFFFFFF80) == 0) {
                    return by2;
                }
                if ((by2 = (byte)(by2 & 0x7F)) == 0) {
                    throw new SnmpException("We don't support indefinite lengths");
                }
                if (by2 > 4) {
                    throw new SnmpException("we can't support data lengths that long" + by2);
                }
                ASNTypes.checkStream(byteArrayInputStream, by2);
                n = 0;
                if (!true) break block5;
                by = by2;
                by2 = (byte)(by - 1);
                if (by <= 0) break block6;
            }
            do {
                n <<= 8;
                n |= ASNTypes.byteStreamToInt(byteArrayInputStream);
                by = by2;
                by2 = (byte)(by - 1);
            } while (by > 0);
        }
        return n;
    }

    public static int byteToInt(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    static int byteStreamToInt(ByteArrayInputStream byteArrayInputStream) {
        int n = byteArrayInputStream.read();
        if (n < 0) {
            return 256 + n;
        }
        return n;
    }

    static void checkStream(ByteArrayInputStream byteArrayInputStream, int n) throws SnmpException {
        if (byteArrayInputStream.available() < n) {
            throw new SnmpException("Parse error: Not enough bytes in Byte stream");
        }
    }

    static boolean IS_CONSTRUCTOR(byte by) {
        return (by & 0x20) != 0;
    }

    static boolean IS_EXTENSION_ID(byte by) {
        return (by & 0x1F) == 31;
    }
}

