/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SASClient;
import Snmp.SnmpAPI;
import Snmp.SnmpCallback;
import Snmp.SnmpClient;
import Snmp.SnmpException;
import Snmp.SnmpIpAddress;
import Snmp.SnmpOID;
import Snmp.SnmpPDU;
import Snmp.SnmpVar;
import Snmp.SnmpVarBind;
import java.applet.Applet;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SnmpSession
extends Thread {
    public boolean CALLBACK_THREAD = false;
    public String community = "public";
    public int retries;
    public int timeout = 5000;
    public String peername;
    public int remote_port;
    public int local_port;
    public static int startLocalPort = 6000;
    public SASClient sasclient;
    public SnmpClient client;
    boolean closeSocket = false;
    private SnmpAPI API;
    private DatagramSocket sock;
    private InetAddress address;
    Vector requestList = new Vector();
    Vector responseList = new Vector();
    Vector timeouts = new Vector();
    int RESP_QUEUE_SIZE = 100;
    int TIMEOUT_QUEUE_SIZE = 50;
    SnmpCallback snmpcallback;

    public SnmpSession(SnmpAPI snmpAPI) {
        this.API = snmpAPI;
        while (this.API.client == null) {
            Thread.yield();
        }
    }

    public void run() {
        this.API.sessionList.addElement(this);
        this.receiver();
    }

    public void open() throws SnmpException {
        try {
            if (this.local_port == 0) {
                this.sock = new DatagramSocket();
                this.local_port = this.sock.getLocalPort();
            } else {
                this.sock = new DatagramSocket(this.local_port);
            }
        }
        catch (SocketException socketException) {
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint(socketException.toString());
                } else {
                    this.client.debugPrint(socketException.toString());
                }
            }
            throw new SnmpException(socketException.toString());
        }
        this.start();
        try {
            Thread.sleep(50L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void open(Applet applet) throws SnmpException {
        try {
            this.sasclient = new SASClient(applet, this.API.DEBUG);
        }
        catch (SnmpException snmpException) {
            this.sasclient = null;
        }
        if (this.sasclient != null && this.sasclient.connected) {
            System.err.println("Connected to remote socket on applet host.");
            this.sasclient.open(this.local_port);
            this.start();
            return;
        }
        this.sasclient = null;
        block4: while (true) {
            try {
                while (true) {
                    if (this.local_port == 0) {
                        this.sock = System.getProperty("browser", "").equals("ActiveX Scripting Host") ? new DatagramSocket(startLocalPort) : new DatagramSocket();
                        this.local_port = this.sock.getLocalPort();
                        break block4;
                    }
                    this.sock = new DatagramSocket(this.local_port);
                }
            }
            catch (SocketException socketException) {
                if (this.API.DEBUG) {
                    if (this.client == null) {
                        this.API.client.debugPrint(socketException.toString());
                    } else {
                        this.client.debugPrint(socketException.toString());
                    }
                }
                ++startLocalPort;
                continue;
            }
            break;
        }
        this.closeSocket = false;
        this.start();
    }

    public void close() {
        this.API.sessionList.removeElement(this);
        if (this.sasclient != null) {
            this.stop();
            this.sasclient.close();
            return;
        }
        this.closeSocket = true;
        this.sock.close();
        if (this.API.DEBUG) {
            if (this.client == null) {
                this.API.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
            } else {
                this.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
            }
        }
        this.stop();
        if (this.snmpcallback != null) {
            this.snmpcallback.stop();
            this.snmpcallback = null;
        }
    }

    public int send(SnmpPDU snmpPDU) throws SnmpException {
        if (snmpPDU.reqid == 0) {
            snmpPDU.reqid = this.API.genReqID();
        }
        if (snmpPDU.address == null) {
            if (snmpPDU.remoteHost == null && this.peername == null) {
                throw new SnmpException("No remote IP address specified.");
            }
            if (snmpPDU.remoteHost == null) {
                snmpPDU.remoteHost = this.peername;
            }
            if (this.sasclient == null) {
                try {
                    snmpPDU.address = InetAddress.getByName(snmpPDU.remoteHost);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new SnmpException("Session Remote Host Unknown.");
                }
            }
        } else if (this.sasclient != null) {
            snmpPDU.remoteHost = SnmpIpAddress.netbToString((byte[])snmpPDU.address.getAddress());
        }
        if (snmpPDU.community == null) {
            snmpPDU.community = this.community;
        }
        if (this.remote_port == 0) {
            this.remote_port = this.API.SNMP_PORT;
        }
        if (snmpPDU.remotePort == 0) {
            snmpPDU.remotePort = this.remote_port;
        }
        if (!snmpPDU.encode()) {
            if (this.API.DEBUG) {
                System.err.println("Unable to encode PDU.");
            }
            throw new SnmpException("Unable to encode PDU.");
        }
        if (this.API.DEBUG) {
            if (this.client == null) {
                this.API.client.debugPrint("Sent Type:" + snmpPDU.command + " Request ID:" + snmpPDU.reqid + " to " + snmpPDU.address + "  : " + snmpPDU.remotePort + "\nDATA\n" + this.printOctets(snmpPDU.data, snmpPDU.data.length));
            } else {
                this.client.debugPrint("Sent Type:" + snmpPDU.command + " Request ID:" + snmpPDU.reqid + " to " + snmpPDU.address + "  : " + snmpPDU.remotePort + "\nDATA\n" + this.printOctets(snmpPDU.data, snmpPDU.data.length));
            }
        }
        if (snmpPDU.command == -96 || snmpPDU.command == -95 || snmpPDU.command == -93) {
            SnmpPDU snmpPDU2 = snmpPDU.copy();
            if (snmpPDU2 != null) {
                snmpPDU2.time_sent = System.currentTimeMillis();
                snmpPDU2.time_expires = snmpPDU2.time_sent + (long)this.timeout;
                snmpPDU2.retries = this.retries;
                this.enQ(this.requestList, snmpPDU2);
                if (this.API.DEBUG) {
                    if (this.client == null) {
                        this.API.client.debugPrint("Placed PDU in request queue.");
                    } else {
                        this.client.debugPrint("Placed PDU in request queue.");
                    }
                }
            } else {
                throw new SnmpException("Cannot clone PDU");
            }
        }
        try {
            if (this.sasclient != null) {
                this.sasclient.send(snmpPDU.remoteHost, snmpPDU.remotePort, snmpPDU.data);
            } else {
                this.sock.send(new DatagramPacket(snmpPDU.data, snmpPDU.data.length, snmpPDU.address, snmpPDU.remotePort));
            }
        }
        catch (IOException iOException) {
            throw new SnmpException("IO error sending PDU.");
        }
        return snmpPDU.reqid;
    }

    public SnmpPDU syncSend(SnmpPDU snmpPDU) throws SnmpException {
        int n;
        this.send(snmpPDU);
        new Date();
        do {
            if ((n = this.checkSyncResponse(snmpPDU.reqid)) != -1) continue;
            return null;
        } while (n <= 0);
        return this.deQ(this.responseList, snmpPDU.reqid);
    }

    synchronized int checkSyncResponse(int n) throws SnmpException {
        int[] nArray = this.checkResponses();
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    return 1;
                }
                ++n2;
            }
        }
        if (this.checkTimeout(n)) {
            return -1;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        return 0;
    }

    public SnmpVar get(String string) throws SnmpException {
        SnmpOID snmpOID = new SnmpOID(string);
        if (snmpOID.toValue() == null) {
            throw new SnmpException("Invalid OID String: " + string);
        }
        return this.snmpRequest((byte)-96, snmpOID, null);
    }

    public SnmpVar get(SnmpOID snmpOID) throws SnmpException {
        return this.snmpRequest((byte)-96, snmpOID, null);
    }

    public SnmpVar getnext(String string) throws SnmpException {
        SnmpOID snmpOID = new SnmpOID(string);
        if (snmpOID.toValue() == null) {
            throw new SnmpException("Invalid OID String: " + string);
        }
        return this.snmpRequest((byte)-95, snmpOID, null);
    }

    public SnmpVar getnext(SnmpOID snmpOID) throws SnmpException {
        return this.snmpRequest((byte)-95, snmpOID, null);
    }

    public SnmpVar set(SnmpOID snmpOID, SnmpVar snmpVar) throws SnmpException {
        return this.snmpRequest((byte)-93, snmpOID, snmpVar);
    }

    SnmpVar snmpRequest(byte by, SnmpOID snmpOID, SnmpVar snmpVar) throws SnmpException {
        SnmpPDU snmpPDU = new SnmpPDU(this.API);
        snmpPDU.command = by;
        if (by == -93) {
            SnmpVarBind snmpVarBind = new SnmpVarBind();
            snmpVarBind.oid = snmpOID;
            snmpVarBind.variable = snmpVar;
            snmpPDU.variables.addElement(snmpVarBind);
        } else {
            snmpPDU.addNull(snmpOID);
        }
        snmpPDU = this.syncSend(snmpPDU);
        if (snmpPDU == null) {
            return null;
        }
        if (snmpPDU.errstat != 0) {
            throw new SnmpException(SnmpException.exceptionString((byte)((byte)snmpPDU.errstat)));
        }
        try {
            return ((SnmpVarBind)snmpPDU.variables.firstElement()).variable;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public SnmpPDU receive(int n) {
        Thread.yield();
        return this.deQ(this.responseList, n);
    }

    public boolean checkTimeout(int n) {
        Enumeration enumeration = this.timeouts.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n != n2) continue;
            this.timeouts.removeElement(n2);
            return true;
        }
        return false;
    }

    public synchronized int[] checkResponses() {
        int n = this.responseList.size();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = ((SnmpPDU)this.responseList.elementAt((int)n2)).reqid;
            ++n2;
        }
        return nArray;
    }

    synchronized void enQ(Vector vector, SnmpPDU snmpPDU) {
        vector.addElement(snmpPDU);
        this.notifyAll();
    }

    synchronized SnmpPDU deQ(Vector vector, int n) {
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPDU snmpPDU = (SnmpPDU)enumeration.nextElement();
            if (n != 0 && snmpPDU.reqid != n) continue;
            vector.removeElement(snmpPDU);
            this.notifyAll();
            return snmpPDU;
        }
        return null;
    }

    synchronized void monitorRequests() {
        SnmpPDU snmpPDU;
        Date date = new Date();
        Enumeration enumeration = this.requestList.elements();
        while (enumeration.hasMoreElements()) {
            snmpPDU = (SnmpPDU)enumeration.nextElement();
            if (date.getTime() <= snmpPDU.time_expires) continue;
            if (snmpPDU.retries <= 0) {
                this.deQ(this.requestList, snmpPDU.reqid);
                if (this.client == null) {
                    if (this.API.client != null && !(this.API.client instanceof SnmpAPI)) {
                        if (this.CALLBACK_THREAD) {
                            if (this.snmpcallback == null) {
                                this.snmpcallback = new SnmpCallback();
                                this.snmpcallback.start();
                            }
                            this.snmpcallback.enQ(this.API.client, this, null, snmpPDU.reqid);
                        } else {
                            this.API.client.callback(this, null, snmpPDU.reqid);
                        }
                    }
                } else if (this.CALLBACK_THREAD) {
                    if (this.snmpcallback == null) {
                        this.snmpcallback = new SnmpCallback();
                        this.snmpcallback.start();
                    }
                    this.snmpcallback.enQ(this.client, this, null, snmpPDU.reqid);
                } else {
                    this.client.callback(this, null, snmpPDU.reqid);
                }
                if (this.timeouts.size() >= this.TIMEOUT_QUEUE_SIZE) {
                    this.timeouts.removeElementAt(0);
                }
                this.timeouts.addElement(new Integer(snmpPDU.reqid));
                if (!this.API.DEBUG) continue;
                String string = snmpPDU.remoteHost;
                if (string == null) {
                    string = snmpPDU.address.toString();
                }
                if (this.client == null) {
                    this.API.client.debugPrint("Timed out: no more retries to " + string + "  : " + snmpPDU.remotePort + "  ReqID: " + snmpPDU.reqid);
                    continue;
                }
                this.client.debugPrint("Timed out: no more retries to " + string + "  : " + snmpPDU.remotePort + "  ReqID: " + snmpPDU.reqid);
                continue;
            }
            --snmpPDU.retries;
            try {
                if (this.sasclient != null) {
                    this.sasclient.send(snmpPDU.remoteHost, snmpPDU.remotePort, snmpPDU.data);
                } else {
                    this.sock.send(new DatagramPacket(snmpPDU.data, snmpPDU.data.length, snmpPDU.address, snmpPDU.remotePort));
                }
            }
            catch (IOException iOException) {
                if (this.sasclient != null) {
                    System.err.println("IO error resending to " + snmpPDU.remoteHost + "  : " + Integer.toString(snmpPDU.remotePort));
                }
                System.err.println("IO error resending to " + snmpPDU.address.toString() + "  : " + Integer.toString(snmpPDU.remotePort));
            }
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Timed out: Resent to " + snmpPDU.address.toString() + "  : " + snmpPDU.remotePort + "  ReqID: " + snmpPDU.reqid);
                } else {
                    this.client.debugPrint("Timed out: Resent to " + snmpPDU.address.toString() + "  : " + snmpPDU.remotePort + "  ReqID: " + snmpPDU.reqid);
                }
            }
            long l = snmpPDU.time_expires - snmpPDU.time_sent;
            snmpPDU.time_sent = date.getTime();
            snmpPDU.time_expires = snmpPDU.time_sent + 2L * l;
        }
        int n = this.responseList.size() - this.RESP_QUEUE_SIZE;
        int n2 = 0;
        while (n2 < n) {
            snmpPDU = this.deQ(this.responseList, 0);
            if (this.timeouts.size() >= this.TIMEOUT_QUEUE_SIZE) {
                this.timeouts.removeElementAt(0);
            }
            this.timeouts.addElement(new Integer(snmpPDU.reqid));
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Resp Queue full: bumped reqid " + snmpPDU.reqid);
                } else {
                    this.client.debugPrint("Resp Queue full: bumped reqid " + snmpPDU.reqid);
                }
            }
            ++n2;
        }
    }

    private void receiver() {
        if (this.API.DEBUG) {
            if (this.client == null) {
                this.API.client.debugPrint("Starting Receiver on this session");
            } else {
                this.client.debugPrint("Starting Receiver on this session");
            }
        }
        byte[] byArray = new byte[8000];
        while (true) {
            if (this.sock != null || this.sasclient != null) {
                Object object;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 8000);
                try {
                    if (this.sasclient != null) {
                        this.sasclient.receive();
                    } else {
                        this.sock.receive(datagramPacket);
                    }
                }
                catch (IOException iOException) {
                    if (this.sasclient == null) {
                        if (!this.closeSocket) continue;
                        this.closeReceiver();
                    }
                    System.err.println("Receive error: Aborting session receiver");
                    this.stop();
                    return;
                }
                catch (SnmpException snmpException) {
                    System.out.println("Receive error: Ignoring the Received message and starting receiver again");
                    continue;
                }
                if (this.closeSocket) {
                    this.closeReceiver();
                    return;
                }
                int n = 0;
                Date date = new Date();
                SnmpPDU snmpPDU = new SnmpPDU(this.API);
                snmpPDU.time_received = date.getTime();
                if (this.sasclient != null) {
                    snmpPDU.data = this.sasclient.data;
                    snmpPDU.remoteHost = this.sasclient.remoteHost;
                    snmpPDU.remotePort = this.sasclient.port;
                    n = this.sasclient.data.length;
                } else {
                    snmpPDU.data = datagramPacket.getData();
                    snmpPDU.address = datagramPacket.getAddress();
                    snmpPDU.remotePort = datagramPacket.getPort();
                    snmpPDU.remoteHost = SnmpIpAddress.netbToString((byte[])snmpPDU.address.getAddress());
                    n = datagramPacket.getLength();
                }
                if (this.API.DEBUG) {
                    object = this.printOctets(snmpPDU.data, n);
                    if (this.client == null) {
                        this.API.client.debugPrint("Packet from: " + snmpPDU.remoteHost + "  : " + snmpPDU.remotePort + "\n" + "DATA:\n" + (String)object + "\n");
                    } else {
                        this.client.debugPrint("Packet from: " + snmpPDU.remoteHost + "  : " + snmpPDU.remotePort + "\n" + "DATA:\n" + (String)object + "\n");
                    }
                }
                try {
                    snmpPDU.decode();
                }
                catch (SnmpException snmpException) {
                    String string = this.printOctets(snmpPDU.data, n);
                    System.err.println("Error decoding Packet: " + (Object)((Object)snmpException));
                    System.err.println("Packet from: " + snmpPDU.remoteHost + "  : " + snmpPDU.remotePort + "\n" + "DATA:\n" + string + "\n");
                    continue;
                }
                if (this.API.DEBUG) {
                    if (this.client == null) {
                        this.API.client.debugPrint("Packet ReqID: " + snmpPDU.reqid);
                    } else {
                        this.client.debugPrint("Packet ReqID: " + snmpPDU.reqid);
                    }
                }
                if (this.community != null) {
                    if (this.client == null) {
                        if (this.API.client != null && !this.API.client.authenticate(snmpPDU, this.community)) {
                            this.API.client.debugPrint("Authentication failure: Our Community: " + this.community + ", Received: " + snmpPDU.community);
                            continue;
                        }
                    } else if (!this.client.authenticate(snmpPDU, this.community)) {
                        this.client.debugPrint("Authentication failure: Our Community: " + this.community + ", Received: " + snmpPDU.community);
                        continue;
                    }
                }
                if ((object = this.deQ(this.requestList, snmpPDU.reqid)) != null) {
                    snmpPDU.time_sent = ((SnmpPDU)object).time_sent;
                }
                if (this.client == null) {
                    if (this.API.client != null && !(this.API.client instanceof SnmpAPI)) {
                        if (this.CALLBACK_THREAD) {
                            if (this.snmpcallback == null) {
                                this.snmpcallback = new SnmpCallback();
                                this.snmpcallback.start();
                            }
                            this.snmpcallback.enQ(this.API.client, this, snmpPDU, snmpPDU.reqid);
                            continue;
                        }
                        if (this.API.client.callback(this, snmpPDU, snmpPDU.reqid)) {
                            continue;
                        }
                    }
                } else {
                    if (this.CALLBACK_THREAD) {
                        if (this.snmpcallback == null) {
                            this.snmpcallback = new SnmpCallback();
                            this.snmpcallback.start();
                        }
                        this.snmpcallback.enQ(this.client, this, snmpPDU, snmpPDU.reqid);
                        continue;
                    }
                    if (this.client.callback(this, snmpPDU, snmpPDU.reqid)) continue;
                }
                this.enQ(this.responseList, snmpPDU);
                continue;
            }
            Thread.yield();
        }
    }

    String printOctets(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (byArray.length < n) {
            n = byArray.length;
        }
        int n3 = 0;
        while (n3 < n) {
            String string;
            if (n2++ > 19) {
                n2 = 1;
                stringBuffer.append("\n");
            }
            if ((string = Integer.toString(ASNTypes.byteToInt((byte)byArray[n3]), 16)).length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(String.valueOf(string) + " ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void closeReceiver() {
        this.sock.close();
        if (this.API.DEBUG) {
            if (this.client == null) {
                this.API.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
            } else {
                this.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
            }
        }
        this.stop();
    }
}

