/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class SgzReader {
    private InflaterInputStream gis;
    private byte[] buf;
    private String elementName;
    private int elementSize;
    private byte[] elementData;

    public SgzReader(InputStream inputStream) throws IOException {
        this.gis = new GZIPInputStream(inputStream);
        this.buf = new byte[1024];
    }

    public String getNextElement() throws IOException {
        this.skipElementData();
        if (this.read(this.buf, 0, 2) != 2) {
            return null;
        }
        int n = this.get2(0);
        if (this.buf.length < n) {
            int n2 = this.buf.length;
            while (n2 < n) {
                n2 *= 2;
            }
            this.buf = new byte[n2];
        }
        if (this.read(this.buf, 0, n) != n) {
            return null;
        }
        this.elementName = new String(this.buf, 0, n);
        if (this.read(this.buf, 0, 4) != 4) {
            return null;
        }
        this.elementSize = (int)this.get4(0);
        this.elementData = null;
        return this.elementName;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public byte[] getElementData() throws IOException {
        if (this.elementData != null) {
            return this.elementData;
        }
        this.elementData = new byte[this.elementSize];
        if (this.read(this.elementData, 0, this.elementSize) != this.elementSize) {
            return null;
        }
        return this.elementData;
    }

    public void close() throws IOException {
        this.gis.close();
    }

    private void skipElementData() throws IOException {
        if (this.elementData != null) {
            return;
        }
        if (this.elementSize == 0) {
            return;
        }
        this.skip(this.elementSize);
    }

    private long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            long l3 = this.gis.skip(l);
            if (l3 < 0L) break;
            l2 += l3;
            l -= l3;
        }
        return l2;
    }

    private int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.gis.read(byArray, n, n2);
            if (n4 < 0) break;
            n3 += n4;
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    private int get2(int n) {
        return this.buf[n] & 0xFF | (this.buf[n + 1] & 0xFF) << 8;
    }

    private long get4(int n) {
        return (long)(this.buf[n] & 0xFF | (this.buf[n + 1] & 0xFF) << 8) | (long)(this.buf[n + 2] & 0xFF) << 16 | (long)(this.buf[n + 3] & 0xFF) << 24;
    }
}

